<?php

namespace Brackets\AdminListing\Tests\Feature\AdminListing;

use Brackets\AdminListing\Tests\TestCase;
use Illuminate\Database\QueryException;

class OrderingTest extends TestCase
{
    /** @test */
    public function listing_should_provide_ability_to_sort_by_name()
    {
        $result = $this->listing
            ->attachOrdering('name')
            ->get();

        $this->assertEquals('Alpha', $result->first()->name);
    }

    /** @test */
    public function listing_should_provide_ability_to_change_sort_order()
    {
        $result = $this->listing
            ->attachOrdering('name', 'desc')
            ->get();

        $this->assertEquals('Alpha', $result->last()->name);
        $this->assertEquals('Zeta 9', $result->first()->name);
    }

    /** @test */
    public function sorting_by_not_existing_column_should_lead_to_an_error()
    {
        try {
            $this->listing
                ->attachOrdering('not_existing_column_name')
                ->get();
        } catch (QueryException $e) {
            $this->assertTrue(true);
            return ;
        }

        $this->fail("Sorting by not existing column should lead to an exception");
    }

    /** @test */
    public function translated_listing_can_be_sorted_by_translated_column()
    {
        $result = $this->translatedListing
            ->attachOrdering('name->en')
            ->get();

        $model = $result->first();

        $this->assertEquals('2000-06-01 00:00:00', $model->published_at);
        $this->assertEquals('Alpha', $model->name);
        $this->assertEquals('red', $model->color);
        $this->assertEquals('red', $model->getTranslation('color', 'en'));
    }

    /** @test */
    public function translated_listing_supports_querying_only_some_columns()
    {
        $result = $this->translatedListing
            ->attachOrdering('name')
            ->get(['published_at', 'name']);

        $model = $result->first();

        $this->assertEquals('2000-06-01 00:00:00', $model->published_at);
        $this->assertEquals('Alpha', $model->name);
        $this->assertEquals(null, $model->color);
        $this->assertEquals('Alpha', $model->getTranslation('name', 'en'));
        $this->assertEquals(null, $model->getTranslation('color', 'en'));
    }

    /** @test */
    public function translated_listing_can_work_with_locales()
    {
        $result = $this->translatedListing
            ->attachOrdering('name')
            ->setLocale('sk')
            ->get();

        $this->assertCount(10, $result);

        $model = $result->first();

        $this->assertEquals('2000-06-01 00:00:00', $model->published_at);
        $this->assertEquals('Alfa', $model->name);
        $this->assertEquals('cervena', $model->color);
        $this->assertEquals('cervena', $model->getTranslation('color', 'sk'));
    }
}
