<?php echo "<?php";
?>


namespace <?php echo e($controllerNamespace); ?>;
<?php
    $activation = $columns->search(function ($column, $key) {
            return $column['name'] === 'activated';
        }) !== false;
?>

<?php if($export): ?>use App\Exports\<?php echo e($exportBaseName); ?>;
<?php endif; ?>
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\<?php echo e($modelWithNamespaceFromDefault); ?>\Destroy<?php echo e($modelBaseName); ?>;
use App\Http\Requests\Admin\<?php echo e($modelWithNamespaceFromDefault); ?>\ImpersonalLogin<?php echo e($modelBaseName); ?>;
use App\Http\Requests\Admin\<?php echo e($modelWithNamespaceFromDefault); ?>\Index<?php echo e($modelBaseName); ?>;
use App\Http\Requests\Admin\<?php echo e($modelWithNamespaceFromDefault); ?>\Store<?php echo e($modelBaseName); ?>;
use App\Http\Requests\Admin\<?php echo e($modelWithNamespaceFromDefault); ?>\Update<?php echo e($modelBaseName); ?>;
use <?php echo e($modelFullName); ?>;
<?php if(count($relations)): ?>
<?php if(count($relations['belongsToMany'])): ?>
<?php $__currentLoopData = $relations['belongsToMany']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $belongsToMany): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
use <?php echo e($belongsToMany['related_model']); ?>;
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php endif; ?>
<?php if($activation): ?>use Brackets\AdminAuth\Activation\Facades\Activation;
<?php endif; ?>
<?php if($activation): ?>use Brackets\AdminAuth\Services\ActivationService;
<?php endif; ?>
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Config;
use Illuminate\View\View;
<?php if($export): ?>use Maatwebsite\Excel\Facades\Excel;
<?php endif; ?>
<?php if($export): ?>use Symfony\Component\HttpFoundation\BinaryFileResponse;
<?php endif; ?>

class <?php echo e($controllerBaseName); ?> extends Controller
{

    /**
     * Guard used for admin user
     *
     * <?php echo e('@'); ?>var string
     */
    protected $guard = 'admin';

    /**
     * AdminUsersController constructor.
     *
     * <?php echo e('@'); ?>return void
     */
    public function __construct()
    {
        $this->guard = config('admin-auth.defaults.guard');
    }

    /**
     * Display a listing of the resource.
     *
     * <?php echo e('@'); ?>param Index<?php echo e($modelBaseName); ?> $request
     * <?php echo e('@'); ?>return Factory|View
     */
    public function index(Index<?php echo e($modelBaseName); ?> $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(<?php echo e($modelBaseName); ?>::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['<?php echo implode('\', \'', $columnsToQuery); ?>'],

            // set columns to searchIn
            ['<?php echo implode('\', \'', $columnsToSearchIn); ?>']
        );

        if ($request->ajax()) {
            return ['data' => $data, 'activation' => Config::get('admin-auth.activation_enabled')];
        }

        return view('admin.<?php echo e($modelDotNotation); ?>.index', ['data' => $data, 'activation' => Config::get('admin-auth.activation_enabled')]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * <?php echo e('@'); ?>throws AuthorizationException
     * <?php echo e('@'); ?>return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.<?php echo e($modelDotNotation); ?>.create');

<?php if(count($relations)): ?>
        return view('admin.<?php echo e($modelDotNotation); ?>.create', [
            'activation' => Config::get('admin-auth.activation_enabled'),
<?php if(count($relations['belongsToMany'])): ?>
<?php $__currentLoopData = $relations['belongsToMany']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $belongsToMany): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if($belongsToMany['related_table'] === 'roles'): ?>
            '<?php echo e($belongsToMany['related_table']); ?>' => <?php echo e($belongsToMany['related_model_name']); ?>::where('guard_name', $this->guard)->get(),
<?php else: ?>
            '<?php echo e($belongsToMany['related_table']); ?>' => <?php echo e($belongsToMany['related_model_name']); ?>::all(),
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
        ]);
<?php else: ?>
        return view('admin.<?php echo e($modelDotNotation); ?>.create');
<?php endif; ?>
    }

    /**
     * Store a newly created resource in storage.
     *
     * <?php echo e('@'); ?>param Store<?php echo e($modelBaseName); ?> $request
     * <?php echo e('@'); ?>return array|RedirectResponse|Redirector
     */
    public function store(Store<?php echo e($modelBaseName); ?> $request)
    {
        // Sanitize input
        $sanitized = $request->getModifiedData();

        // Store the <?php echo e($modelBaseName); ?>

        $<?php echo e($modelVariableName); ?> = <?php echo e($modelBaseName); ?>::create($sanitized);

<?php if(count($relations)): ?>
<?php if(count($relations['belongsToMany'])): ?>
<?php $__currentLoopData = $relations['belongsToMany']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $belongsToMany): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        // But we do have a <?php echo e($belongsToMany['related_table']); ?>, so we need to attach the <?php echo e($belongsToMany['related_table']); ?> to the <?php echo e($modelVariableName); ?>

        $<?php echo e($modelVariableName); ?>-><?php echo e($belongsToMany['related_table']); ?>()->sync(collect($request->input('<?php echo e($belongsToMany['related_table']); ?>', []))->map->id->toArray());
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php endif; ?>
<?php endif; ?>
        if ($request->ajax()) {
            return ['redirect' => url('admin/<?php echo e($resource); ?>'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/<?php echo e($resource); ?>');
    }

    /**
     * Display the specified resource.
     *
     * <?php echo e('@'); ?>param <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>

     * <?php echo e('@'); ?>throws AuthorizationException
     * <?php echo e('@'); ?>return void
     */
    public function show(<?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>)
    {
        $this->authorize('admin.<?php echo e($modelDotNotation); ?>.show', $<?php echo e($modelVariableName); ?>);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * <?php echo e('@'); ?>param <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>

     * <?php echo e('@'); ?>throws AuthorizationException
     * <?php echo e('@'); ?>return Factory|View
     */
    public function edit(<?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>)
    {
        $this->authorize('admin.<?php echo e($modelDotNotation); ?>.edit', $<?php echo e($modelVariableName); ?>);

<?php if(count($relations)): ?>
<?php if(count($relations['belongsToMany'])): ?>
<?php $__currentLoopData = $relations['belongsToMany']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $belongsToMany): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        $<?php echo e($modelVariableName); ?>->load('<?php echo e($belongsToMany['related_table']); ?>');
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php endif; ?>
<?php endif; ?>
        return view('admin.<?php echo e($modelDotNotation); ?>.edit', [
            '<?php echo e($modelVariableName); ?>' => $<?php echo e($modelVariableName); ?>,
            'activation' => Config::get('admin-auth.activation_enabled'),
<?php if(count($relations)): ?>
<?php if(count($relations['belongsToMany'])): ?>
<?php $__currentLoopData = $relations['belongsToMany']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $belongsToMany): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if($belongsToMany['related_table'] === 'roles'): ?>
            '<?php echo e($belongsToMany['related_table']); ?>' => <?php echo e($belongsToMany['related_model_name']); ?>::where('guard_name', $this->guard)->get(),
<?php else: ?>
            '<?php echo e($belongsToMany['related_table']); ?>' => <?php echo e($belongsToMany['related_model_name']); ?>::all(),
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php endif; ?>
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * <?php echo e('@'); ?>param Update<?php echo e($modelBaseName); ?> $request
     * <?php echo e('@'); ?>param <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>

     * <?php echo e('@'); ?>return array|RedirectResponse|Redirector
     */
    public function update(Update<?php echo e($modelBaseName); ?> $request, <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>)
    {
        // Sanitize input
        $sanitized = $request->getModifiedData();

        // Update changed values <?php echo e($modelBaseName); ?>

        $<?php echo e($modelVariableName); ?>->update($sanitized);

<?php if(count($relations)): ?>
<?php if(count($relations['belongsToMany'])): ?>
<?php $__currentLoopData = $relations['belongsToMany']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $belongsToMany): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        // But we do have a <?php echo e($belongsToMany['related_table']); ?>, so we need to attach the <?php echo e($belongsToMany['related_table']); ?> to the <?php echo e($modelVariableName); ?>

        if ($request->input('<?php echo e($belongsToMany['related_table']); ?>')) {
            $<?php echo e($modelVariableName); ?>-><?php echo e($belongsToMany['related_table']); ?>()->sync(collect($request->input('<?php echo e($belongsToMany['related_table']); ?>', []))->map->id->toArray());
        }
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php endif; ?>

        if ($request->ajax()) {
            return ['redirect' => url('admin/<?php echo e($resource); ?>'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/<?php echo e($resource); ?>');
    }

    /**
     * Remove the specified resource from storage.
     *
     * <?php echo e('@'); ?>param Destroy<?php echo e($modelBaseName); ?> $request
     * <?php echo e('@'); ?>param <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>

     * <?php echo e('@'); ?>throws Exception
     * <?php echo e('@'); ?>return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(Destroy<?php echo e($modelBaseName); ?> $request, <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>)
    {
        $<?php echo e($modelVariableName); ?>->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

<?php if($activation): ?>
    /**
     * Resend activation e-mail
     *
     * <?php echo e('@'); ?>param Request $request
     * <?php echo e('@'); ?>param ActivationService $activationService
     * <?php echo e('@'); ?>param <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>

     * <?php echo e('@'); ?>return array|RedirectResponse
     */
    public function resendActivationEmail(Request $request, ActivationService $activationService, <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>)
    {
        if (Config::get('admin-auth.activation_enabled')) {
            $response = $activationService->handle($<?php echo e($modelVariableName); ?>);
            if ($response == Activation::ACTIVATION_LINK_SENT) {
                if ($request->ajax()) {
                    return ['message' => trans('brackets/admin-ui::admin.operation.succeeded')];
                }

                return redirect()->back();
            } else {
                if ($request->ajax()) {
                    abort(409, trans('brackets/admin-ui::admin.operation.failed'));
                }

                return redirect()->back();
            }
        } else {
            if ($request->ajax()) {
                abort(400, trans('brackets/admin-ui::admin.operation.not_allowed'));
            }

            return redirect()->back();
        }
    }
<?php endif; ?>

    /**
     * <?php echo e('@'); ?>param ImpersonalLogin<?php echo e($modelBaseName); ?> $request
     * <?php echo e('@'); ?>param <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>

     * <?php echo e('@'); ?>return RedirectResponse
     * @throws AuthorizationException
     */
    public function impersonalLogin(ImpersonalLogin<?php echo e($modelBaseName); ?> $request, <?php echo e($modelBaseName); ?> $<?php echo e($modelVariableName); ?>) {
        Auth::login($<?php echo e($modelVariableName); ?>);
        return redirect()->back();
    }

<?php if($export): ?>

    /**
     * Export entities
     *
     * <?php echo e('@'); ?>return BinaryFileResponse|null
     */
    public function export(): ?BinaryFileResponse
    {
        return Excel::download(app(<?php echo e($exportBaseName); ?>::class), '<?php echo e(str_plural($modelVariableName)); ?>.xlsx');
    }
<?php endif; ?>}
<?php /**PATH C:\xampp\htdocs\diamond\vendor\brackets\admin-generator\src/../resources/views/templates/admin-user/controller.blade.php ENDPATH**/ ?>