<?php echo "<?php"
?>


namespace <?php echo e($controllerNamespace); ?>;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;
use Illuminate\View\View;

class ProfileController extends Controller
{
    public $<?php echo e($modelVariableName); ?>;

    /**
     * Guard used for admin user
     *
     * <?php echo e('@'); ?>var string
     */
    protected $guard = 'admin';

    public function __construct()
    {
        // TODO add authorization
        $this->guard = config('admin-auth.defaults.guard');
    }

    /**
     * Get logged user before each method
     *
     * <?php echo e('@'); ?>param Request $request
     */
    protected function setUser($request)
    {
        if (empty($request->user($this->guard))) {
            abort(404, 'Admin User not found');
        }

        $this-><?php echo e($modelVariableName); ?> = $request->user($this->guard);
    }

    /**
     * Show the form for editing logged user profile.
     *
     * <?php echo e('@'); ?>param Request $request
     * <?php echo e('@'); ?>return Factory|View
     */
    public function editProfile(Request $request)
    {
        $this->setUser($request);

        return view('admin.profile.edit-profile', [
            '<?php echo e($modelVariableName); ?>' => $this-><?php echo e($modelVariableName); ?>,
        ]);
    }
<?php
    $columnsProfile = $columns->reject(function($column) {
        return in_array($column['name'], ['password', 'activated', 'forbidden']);
    });
?>

    /**
     * Update the specified resource in storage.
     *
     * <?php echo e('@'); ?>param Request $request
     * <?php echo e('@'); ?>throws ValidationException
     * <?php echo e('@'); ?>return array|RedirectResponse|Redirector
     */
    public function updateProfile(Request $request)
    {
        $this->setUser($request);
        $<?php echo e($modelVariableName); ?> = $this-><?php echo e($modelVariableName); ?>;

        // Validate the request
        $this->validate($request, [
            <?php $__currentLoopData = $columnsProfile; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>'<?php echo e($column['name']); ?>' => [<?php echo implode(', ', (array) $column['serverUpdateRules']); ?>],
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        ]);

        // Sanitize input
        $sanitized = $request->only([
            <?php $__currentLoopData = $columnsProfile; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>'<?php echo e($column['name']); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        ]);

        // Update changed values <?php echo e($modelBaseName); ?>

        $this-><?php echo e($modelVariableName); ?>->update($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/profile'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/profile');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * <?php echo e('@'); ?>param Request $request
     * <?php echo e('@'); ?>return Factory|View
     */
    public function editPassword(Request $request)
    {
        $this->setUser($request);

        return view('admin.profile.edit-password', [
            '<?php echo e($modelVariableName); ?>' => $this-><?php echo e($modelVariableName); ?>,
        ]);
    }

<?php
    $columnsPassword = $columns->reject(function($column) {
        return !in_array($column['name'], ['password']);
    });
?>

    /**
     * Update the specified resource in storage.
     *
     * <?php echo e('@'); ?>param Request $request
     * <?php echo e('@'); ?>throws ValidationException
     * <?php echo e('@'); ?>return array|RedirectResponse|Redirector
     */
    public function updatePassword(Request $request)
    {
        $this->setUser($request);
        $<?php echo e($modelVariableName); ?> = $this-><?php echo e($modelVariableName); ?>;

        // Validate the request
        $this->validate($request, [
            <?php $__currentLoopData = $columnsPassword; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>'<?php echo e($column['name']); ?>' => [<?php echo implode(', ', (array) $column['serverUpdateRules']); ?>],
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        ]);

        // Sanitize input
        $sanitized = $request->only([
            <?php $__currentLoopData = $columnsPassword; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>'<?php echo e($column['name']); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        ]);

        //Modify input, set hashed password
        $sanitized['password'] = Hash::make($sanitized['password']);

        // Update changed values <?php echo e($modelBaseName); ?>

        $this-><?php echo e($modelVariableName); ?>->update($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/password'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/password');
    }
}
<?php /**PATH C:\xampp\htdocs\diamond\vendor\brackets\admin-generator\src/../resources/views/templates/profile/controller.blade.php ENDPATH**/ ?>