<?php $__env->startSection('title', trans('admin.order.actions.index')); ?>

<?php $__env->startSection('body'); ?>

    <order-listing
        :data="<?php echo e($data->toJson()); ?>"
        :url="'<?php echo e(url('admin/orders')); ?>'"
        inline-template>

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <i class="ti-align-justify"></i> <?php echo e(trans('admin.order.actions.index')); ?>

                        <a class="btn btn-primary btn-spinner btn-sm pull-right m-b-0" href="<?php echo e(url('admin/orders/create')); ?>" role="button"><i class="ti-plus"></i>&nbsp; <?php echo e(trans('admin.order.actions.create')); ?></a>
                    </div>
                    <div class="card-content" v-cloak>
                        <div class="card-block">
                            <form @submit.prevent="">
                                <div class="row justify-content-md-between">
                                        <div class="col col-lg-12 col-xl-5 form-group search-box">
                                            <div class="input-group search-bar">
                                                <input class="form-control" placeholder="<?php echo e(trans('brackets/admin-ui::admin.placeholder.search')); ?>" v-model="search" @keyup.enter="filter('search', $event.target.value)" />
                                                <span class="btn btn-primary input-group-addon search-logo" @click="filter('search', search)"><i class="ti-search"></i></span>
                                            </div>

                                            <label>
                                                <select class="form-control" v-model="pagination.state.per_page">
                                                    <option value="10">10</option>
                                                    <option value="25">25</option>
                                                    <option value="100">100</option>
                                                </select>
                                            </label>
                                        </div>
                                </div>
                            </form>

                            <table class="table table-hover table-listing">
                                <thead>
                                    <tr>
                                        

                                        <th is='sortable' :column="'id'"><?php echo e(trans('admin.order.columns.id')); ?></th>
                                        <th is='sortable' :column="'customer_id'"><?php echo e(trans('admin.order.columns.customer_id')); ?></th>
                                        
                                        <th is='sortable' :column="'product_type'"><?php echo e(trans('admin.order.columns.product_type')); ?></th>
                                        
                                        <th is='sortable' :column="'metal_type'"><?php echo e(trans('admin.order.columns.metal_type')); ?></th>
                                        
                                        

                                        
                                        <th is='sortable' :column="'priority'"><?php echo e(trans('admin.order.columns.priority')); ?></th>
                                        
                                        <th is='sortable' :column="'status'"><?php echo e(trans('admin.order.columns.status')); ?></th>
                                        
                                        <th is='sortable' :column="'order_date'"><?php echo e(trans('admin.order.columns.order_date')); ?></th>
                                        <th is='sortable' :column="'due_date'"><?php echo e(trans('admin.order.columns.due_date')); ?></th>
                                        <th is='sortable' :column="'actions'"><?php echo e(trans('Actions')); ?></th>
                                    </tr>
                                    <tr v-show="(clickedBulkItemsCount > 0) || isClickedAll">
                                        <td class="bg-bulk-info d-table-cell text-center" colspan="28">
                                            <span class="align-middle font-weight-light text-dark"><?php echo e(trans('brackets/admin-ui::admin.listing.selected_items')); ?> {{ clickedBulkItemsCount }}.  <a href="#" class="text-primary" @click="onBulkItemsClickedAll('/admin/orders')" v-if="(clickedBulkItemsCount < pagination.state.total)"> <i class="fa" :class="bulkCheckingAllLoader ? 'fa-spinner' : ''"></i> <?php echo e(trans('brackets/admin-ui::admin.listing.check_all_items')); ?> {{ pagination.state.total }}</a> <span class="text-primary">|</span> <a
                                                        href="#" class="text-primary" @click="onBulkItemsClickedAllUncheck()"><?php echo e(trans('brackets/admin-ui::admin.listing.uncheck_all_items')); ?></a>  </span>

                                            <span class="pull-right pr-2">
                                                <button class="btn btn-sm btn-danger pr-3 pl-3" @click="bulkDelete('/admin/orders/bulk-destroy')"><?php echo e(trans('brackets/admin-ui::admin.btn.delete')); ?></button>
                                            </span>

                                        </td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(item, index) in collection" :key="item.id" :class="bulkItems[item.id] ? 'bg-bulk' : ''">
                                        

                                    <td>{{ item.id }}</td>
                                        
                                        <td>{{ item.customer.first_name ?? '-'}}</td>
                                        
                                        <td>{{ item.product_type.product_type ?? '-'}}</td>
                                        
                                        <td>{{ item.metal_type.metal_type ?? '-'}}</td>
                                        
                                        
                                        
                                        
                                        
                                        
                                        <td>
                                            <span v-if="item.priority.id === 1" class="badge badge-priority" style="background-color: #EB5E28;">{{ item.priority.priority }}</span>
                                            <span v-else-if="item.priority.id === 2" class="badge badge-priority" style="background-color:#F3BB45;">{{ item.priority.priority }}</span>
                                            <span v-else-if="item.priority.id === 3" class="badge badge-priority" style="background-color: #7AC29A;">{{ item.priority.priority }}</span>
                                            <span v-else class="badge badge-priority">{{ item.priority.priority }}</span>
                                        </td>
                                        
                                        <td>{{ item.status }}</td>
                                        
                                        <td>{{ item.order_date | datetime }}</td>
                                        <td>{{ item.due_date | datetime }}</td>
                                        
                                        <td>
                                            <div class="table-icons">
                                                <a class="btn btn-simple btn-info btn-icon table-action view" :href="item.resource_url + '/view'" title="<?php echo e(trans('brackets/admin-ui::admin.btn.view')); ?>" role="button"><i class="ti-eye"></i></a>
                                                <a class="btn btn-simple btn-info btn-icon table-action view" :href="item.resource_url + '/edit'" title="<?php echo e(trans('brackets/admin-ui::admin.btn.edit')); ?>" role="button"><i class="ti-pencil-alt"></i></a>                                         
                                                
                                                <a class="btn btn-simple btn-info btn-icon table-action remove" href="#" @click.prevent="deleteItem(item.resource_url)" title="<?php echo e(trans('brackets/admin-ui::admin.btn.delete')); ?>" role="button">
                                                    <i class="ti-close"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                            <div class="row pagination-margin" v-if="pagination.state.total > 0">
                                <div class="col-sm">
                                    <span class="pagination-caption"><?php echo e(trans('brackets/admin-ui::admin.pagination.overview')); ?></span>
                                </div>
                                <div class="col-sm-auto">
                                    <pagination></pagination>
                                </div>
                            </div>

                            <div class="no-items-found" v-if="!collection.length > 0">
                                <i class="icon-magnifier"></i>
                                <h3><?php echo e(trans('brackets/admin-ui::admin.index.no_items')); ?></h3>
                                <p><?php echo e(trans('brackets/admin-ui::admin.index.try_changing_items')); ?></p>
                                <a class="btn btn-primary btn-spinner" href="<?php echo e(url('admin/orders/create')); ?>" role="button"><i class="ti-plus"></i>&nbsp; <?php echo e(trans('admin.order.actions.create')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </order-listing>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.paper-theme-layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diamond\resources\views/admin/order/index.blade.php ENDPATH**/ ?>