<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('admin-users')->name('admin-users/')->group(static function() {
            Route::get('/',                                             'AdminUsersController@index')->name('index');
            Route::get('/create',                                       'AdminUsersController@create')->name('create');
            Route::post('/',                                            'AdminUsersController@store')->name('store');
            Route::get('/{adminUser}/impersonal-login',                 'AdminUsersController@impersonalLogin')->name('impersonal-login');
            Route::get('/{adminUser}/edit',                             'AdminUsersController@edit')->name('edit');
            Route::post('/{adminUser}',                                 'AdminUsersController@update')->name('update');
            Route::delete('/{adminUser}',                               'AdminUsersController@destroy')->name('destroy');
            Route::get('/{adminUser}/resend-activation',                'AdminUsersController@resendActivationEmail')->name('resendActivationEmail');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::get('/profile',                                      'ProfileController@editProfile')->name('edit-profile');
        Route::post('/profile',                                     'ProfileController@updateProfile')->name('update-profile');
        Route::get('/password',                                     'ProfileController@editPassword')->name('edit-password');
        Route::post('/password',                                    'ProfileController@updatePassword')->name('update-password');
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('countries')->name('countries/')->group(static function() {
            Route::get('/',                                             'CountriesController@index')->name('index');
            Route::get('/create',                                       'CountriesController@create')->name('create');
            Route::post('/',                                            'CountriesController@store')->name('store');
            Route::get('/{country}/edit',                               'CountriesController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'CountriesController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{country}',                                   'CountriesController@update')->name('update');
            Route::delete('/{country}',                                 'CountriesController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('diamond-types')->name('diamond-types/')->group(static function() {
            Route::get('/',                                             'DiamondTypeController@index')->name('index');
            Route::get('/create',                                       'DiamondTypeController@create')->name('create');
            Route::post('/',                                            'DiamondTypeController@store')->name('store');
            Route::get('/{diamondType}/edit',                           'DiamondTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'DiamondTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{diamondType}',                               'DiamondTypeController@update')->name('update');
            Route::delete('/{diamondType}',                             'DiamondTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('diamond-shapes')->name('diamond-shapes/')->group(static function() {
            Route::get('/',                                             'DiamondShapeController@index')->name('index');
            Route::get('/create',                                       'DiamondShapeController@create')->name('create');
            Route::post('/',                                            'DiamondShapeController@store')->name('store');
            Route::get('/{diamondShape}/edit',                          'DiamondShapeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'DiamondShapeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{diamondShape}',                              'DiamondShapeController@update')->name('update');
            Route::delete('/{diamondShape}',                            'DiamondShapeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('stone-colors')->name('stone-colors/')->group(static function() {
            Route::get('/',                                             'StoneColorController@index')->name('index');
            Route::get('/create',                                       'StoneColorController@create')->name('create');
            Route::post('/',                                            'StoneColorController@store')->name('store');
            Route::get('/{stoneColor}/edit',                            'StoneColorController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'StoneColorController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{stoneColor}',                                'StoneColorController@update')->name('update');
            Route::delete('/{stoneColor}',                              'StoneColorController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('metal-types')->name('metal-types/')->group(static function() {
            Route::get('/',                                             'MetalTypeController@index')->name('index');
            Route::get('/create',                                       'MetalTypeController@create')->name('create');
            Route::post('/',                                            'MetalTypeController@store')->name('store');
            Route::get('/{metalType}/edit',                             'MetalTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'MetalTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{metalType}',                                 'MetalTypeController@update')->name('update');
            Route::delete('/{metalType}',                               'MetalTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('metal-purities')->name('metal-purities/')->group(static function() {
            Route::get('/',                                             'MetalPurityController@index')->name('index');
            Route::get('/create',                                       'MetalPurityController@create')->name('create');
            Route::post('/',                                            'MetalPurityController@store')->name('store');
            Route::get('/{metalPurity}/edit',                           'MetalPurityController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'MetalPurityController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{metalPurity}',                               'MetalPurityController@update')->name('update');
            Route::delete('/{metalPurity}',                             'MetalPurityController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('metal-tones')->name('metal-tones/')->group(static function() {
            Route::get('/',                                             'MetalToneController@index')->name('index');
            Route::get('/create',                                       'MetalToneController@create')->name('create');
            Route::post('/',                                            'MetalToneController@store')->name('store');
            Route::get('/{metalTone}/edit',                             'MetalToneController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'MetalToneController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{metalTone}',                                 'MetalToneController@update')->name('update');
            Route::delete('/{metalTone}',                               'MetalToneController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('closures')->name('closures/')->group(static function() {
            Route::get('/',                                             'ClosureController@index')->name('index');
            Route::get('/create',                                       'ClosureController@create')->name('create');
            Route::post('/',                                            'ClosureController@store')->name('store');
            Route::get('/{closure}/edit',                               'ClosureController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'ClosureController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{closure}',                                   'ClosureController@update')->name('update');
            Route::delete('/{closure}',                                 'ClosureController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('ring-sizes')->name('ring-sizes/')->group(static function() {
            Route::get('/',                                             'RingSizeController@index')->name('index');
            Route::get('/create',                                       'RingSizeController@create')->name('create');
            Route::post('/',                                            'RingSizeController@store')->name('store');
            Route::get('/{ringSize}/edit',                              'RingSizeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'RingSizeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{ringSize}',                                  'RingSizeController@update')->name('update');
            Route::delete('/{ringSize}',                                'RingSizeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('carat-weights')->name('carat-weights/')->group(static function() {
            Route::get('/',                                             'CaratWeightController@index')->name('index');
            Route::get('/create',                                       'CaratWeightController@create')->name('create');
            Route::post('/',                                            'CaratWeightController@store')->name('store');
            Route::get('/{caratWeight}/edit',                           'CaratWeightController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'CaratWeightController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{caratWeight}',                               'CaratWeightController@update')->name('update');
            Route::delete('/{caratWeight}',                             'CaratWeightController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('wrist-sizes')->name('wrist-sizes/')->group(static function() {
            Route::get('/',                                             'WristSizeController@index')->name('index');
            Route::get('/create',                                       'WristSizeController@create')->name('create');
            Route::post('/',                                            'WristSizeController@store')->name('store');
            Route::get('/{wristSize}/edit',                             'WristSizeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'WristSizeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{wristSize}',                                 'WristSizeController@update')->name('update');
            Route::delete('/{wristSize}',                               'WristSizeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('party-names')->name('party-names/')->group(static function() {
            Route::get('/',                                             'PartyNameController@index')->name('index');
            Route::get('/create',                                       'PartyNameController@create')->name('create');
            Route::post('/',                                            'PartyNameController@store')->name('store');
            Route::get('/{partyName}/edit',                             'PartyNameController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'PartyNameController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{partyName}',                                 'PartyNameController@update')->name('update');
            Route::delete('/{partyName}',                               'PartyNameController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('broker-names')->name('broker-names/')->group(static function() {
            Route::get('/',                                             'BrokerNameController@index')->name('index');
            Route::get('/create',                                       'BrokerNameController@create')->name('create');
            Route::post('/',                                            'BrokerNameController@store')->name('store');
            Route::get('/{brokerName}/edit',                            'BrokerNameController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'BrokerNameController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{brokerName}',                                'BrokerNameController@update')->name('update');
            Route::delete('/{brokerName}',                              'BrokerNameController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('lock-types')->name('lock-types/')->group(static function() {
            Route::get('/',                                             'LockTypeController@index')->name('index');
            Route::get('/create',                                       'LockTypeController@create')->name('create');
            Route::post('/',                                            'LockTypeController@store')->name('store');
            Route::get('/{lockType}/edit',                              'LockTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'LockTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{lockType}',                                  'LockTypeController@update')->name('update');
            Route::delete('/{lockType}',                                'LockTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('polish-types')->name('polish-types/')->group(static function() {
            Route::get('/',                                             'PolishTypeController@index')->name('index');
            Route::get('/create',                                       'PolishTypeController@create')->name('create');
            Route::post('/',                                            'PolishTypeController@store')->name('store');
            Route::get('/{polishType}/edit',                            'PolishTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'PolishTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{polishType}',                                'PolishTypeController@update')->name('update');
            Route::delete('/{polishType}',                              'PolishTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('prongs-types')->name('prongs-types/')->group(static function() {
            Route::get('/',                                             'ProngsTypeController@index')->name('index');
            Route::get('/create',                                       'ProngsTypeController@create')->name('create');
            Route::post('/',                                            'ProngsTypeController@store')->name('store');
            Route::get('/{prongsType}/edit',                            'ProngsTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'ProngsTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{prongsType}',                                'ProngsTypeController@update')->name('update');
            Route::delete('/{prongsType}',                              'ProngsTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('priorities')->name('priorities/')->group(static function() {
            Route::get('/',                                             'PriorityController@index')->name('index');
            Route::get('/create',                                       'PriorityController@create')->name('create');
            Route::post('/',                                            'PriorityController@store')->name('store');
            Route::get('/{priority}/edit',                              'PriorityController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'PriorityController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{priority}',                                  'PriorityController@update')->name('update');
            Route::delete('/{priority}',                                'PriorityController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('product-types')->name('product-types/')->group(static function() {
            Route::get('/',                                             'ProductTypeController@index')->name('index');
            Route::get('/create',                                       'ProductTypeController@create')->name('create');
            Route::post('/',                                            'ProductTypeController@store')->name('store');
            Route::get('/{productType}/edit',                           'ProductTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'ProductTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{productType}',                               'ProductTypeController@update')->name('update');
            Route::delete('/{productType}',                             'ProductTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('customers')->name('customers/')->group(static function() {
            Route::get('/',                                             'CustomersController@index')->name('index');
            Route::get('/create',                                       'CustomersController@create')->name('create');
            Route::post('/',                                            'CustomersController@store')->name('store');
            Route::get('/{customer}/edit',                              'CustomersController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'CustomersController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{customer}',                                  'CustomersController@update')->name('update');
            Route::delete('/{customer}',                                'CustomersController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('bale-types')->name('bale-types/')->group(static function() {
            Route::get('/',                                             'BaleTypeController@index')->name('index');
            Route::get('/create',                                       'BaleTypeController@create')->name('create');
            Route::post('/',                                            'BaleTypeController@store')->name('store');
            Route::get('/{baleType}/edit',                              'BaleTypeController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'BaleTypeController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{baleType}',                                  'BaleTypeController@update')->name('update');
            Route::delete('/{baleType}',                                'BaleTypeController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('orders')->name('orders/')->group(static function() {
            Route::get('/',                                             'OrdersController@index')->name('index');
            Route::get('/create',                                       'OrdersController@create')->name('create');
            Route::post('/',                                            'OrdersController@store')->name('store');
            Route::get('/{order}/view',                                 'OrdersController@view')->name('view');  // Added view route
            Route::get('/{order}/edit',                                 'OrdersController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'OrdersController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{order}',                                     'OrdersController@update')->name('update');
            Route::delete('/{order}',                                   'OrdersController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('diamond-orders')->name('diamond-orders/')->group(static function() {
            Route::get('/',                                             'DiamondOrderController@index')->name('index');
            Route::get('/create',                                       'DiamondOrderController@create')->name('create');
            Route::post('/',                                            'DiamondOrderController@store')->name('store');
            Route::get('/{diamondOrder}/edit',                          'DiamondOrderController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'DiamondOrderController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{diamondOrder}',                              'DiamondOrderController@update')->name('update');
            Route::delete('/{diamondOrder}',                            'DiamondOrderController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('roles')->name('roles/')->group(static function() {
            Route::get('/',                                             'RolesController@index')->name('index');
            Route::get('/create',                                       'RolesController@create')->name('create');
            Route::post('/',                                            'RolesController@store')->name('store');
            Route::get('/{role}/edit',                                  'RolesController@edit')->name('edit');
            Route::get('/{role}',                                       'RolesController@role')->name('rolepermission');
            Route::post('/{role}/rolepermission',                      'RolesController@permissioncheck')->name('rolepermission');
            Route::post('/bulk-destroy',                                'RolesController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{role}',                                      'RolesController@update')->name('update');
            Route::delete('/{role}',                                    'RolesController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('permissions')->name('permissions/')->group(static function() {
            Route::get('/',                                             'PermissionsController@index')->name('index');
            Route::get('/create',                                       'PermissionsController@create')->name('create');
            Route::post('/',                                            'PermissionsController@store')->name('store');
            Route::get('/{permission}/edit',                            'PermissionsController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'PermissionsController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{permission}',                                'PermissionsController@update')->name('update');
            Route::delete('/{permission}',                              'PermissionsController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('qc-departments')->name('qc-departments/')->group(static function() {
            Route::get('/',                                             'QcDepartmentController@index')->name('index');
            Route::get('/create',                                       'QcDepartmentController@create')->name('create');
            Route::post('/',                                            'QcDepartmentController@store')->name('store');
            Route::get('/{qcDepartment}/edit',                          'QcDepartmentController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'QcDepartmentController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{qcDepartment}',                              'QcDepartmentController@update')->name('update');
            Route::delete('/{qcDepartment}',                            'QcDepartmentController@destroy')->name('destroy');
        });
    });
});

/* Auto-generated admin routes */
Route::middleware(['auth:' . config('admin-auth.defaults.guard'), 'admin'])->group(static function () {
    Route::prefix('admin')->namespace('App\Http\Controllers\Admin')->name('admin/')->group(static function() {
        Route::prefix('qc-questions')->name('qc-questions/')->group(static function() {
            Route::get('/',                                             'QcQuestionsController@index')->name('index');
            Route::get('/create',                                       'QcQuestionsController@create')->name('create');
            Route::post('/',                                            'QcQuestionsController@store')->name('store');
            Route::get('/{qcQuestion}/edit',                            'QcQuestionsController@edit')->name('edit');
            Route::post('/bulk-destroy',                                'QcQuestionsController@bulkDestroy')->name('bulk-destroy');
            Route::post('/{qcQuestion}',                                'QcQuestionsController@update')->name('update');
            Route::delete('/{qcQuestion}',                              'QcQuestionsController@destroy')->name('destroy');
        });
    });
});