@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.wrist-size.actions.edit', ['name' => $wristSize->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <wrist-size-form
                :action="'{{ $wristSize->resource_url }}'"
                :data="{{ $wristSize->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.wrist-size.actions.edit', ['name' => $wristSize->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.wrist-size.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </wrist-size-form>

        </div>
    
</div>

@endsection