@extends('admin.paper-theme-layout.default')


@section('title', trans('admin.stone-color.actions.edit', ['name' => $stoneColor->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <stone-color-form
                :action="'{{ $stoneColor->resource_url }}'"
                :data="{{ $stoneColor->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.stone-color.actions.edit', ['name' => $stoneColor->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.stone-color.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </stone-color-form>

        </div>
    
</div>

@endsection