@extends('admin.paper-theme-layout.default')
@section('title', trans('Role Permissions'))
@section('body')
<div class="row">
    <div class="col">
        <div class="card">
            <div class="card-header">
                <i class="fa fa-align-justify"></i> {{ trans('Role Permissions') }}
            </div>
            <div class="card-content" v-cloak>
                <div class="card-block">
                    <form action="{{ url('admin/roles/'.$role->id.'/rolepermission/') }}" method="POST" id="permissionsForm">
                        @csrf
                        @php $counter = 0; @endphp
                        @foreach ($permissions as $per)
                            @if ($counter % 3 == 0)
                                @if ($counter > 0)
                                    </div>
                                @endif
                                <div class="row">
                            @endif
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="{{ $per->id }}" id="flexCheckChecked{{ $per->id }}"
                                    {{ collect($permissionsForRoles)->contains(function ($item) use ($per) {
                                        return collect($item)->contains('permission_id', $per->id);
                                    }) ? 'checked' : '' }}
                                    >
                                    <label class="form-check-label" for="flexCheckChecked{{ $per->id }}">
                                        {{ $per->name }}
                                    </label>
                                </div>
                            </div>
                            @php $counter++; @endphp
                        @endforeach
                        </div>
                        <button type="submit" class="btn btn-sm btn-primary flex-end" title="{{ trans('brackets/admin-ui::admin.btn.delete') }}" style="float:right; margin:25px 10px 10px 25px">submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
