@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.ring-size.actions.edit', ['name' => $ringSize->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <ring-size-form
                :action="'{{ $ringSize->resource_url }}'"
                :data="{{ $ringSize->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.ring-size.actions.edit', ['name' => $ringSize->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.ring-size.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </ring-size-form>

        </div>
    
</div>

@endsection