@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.qc-question.actions.edit', ['name' => $qcQuestion->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <qc-question-form
                :action="'{{ $qcQuestion->resource_url }}'"
                :data="{{ $qcQuestion->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.qc-question.actions.edit', ['name' => $qcQuestion->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.qc-question.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </qc-question-form>

        </div>
    
</div>

@endsection