@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.prongs-type.actions.edit', ['name' => $prongsType->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <prongs-type-form
                :action="'{{ $prongsType->resource_url }}'"
                :data="{{ $prongsType->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.prongs-type.actions.edit', ['name' => $prongsType->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.prongs-type.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </prongs-type-form>

        </div>
    
</div>

@endsection