@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.product-type.actions.edit', ['name' => $productType->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

        <product-type-form
                :action="'{{ $productType->resource_url }}'"
                :data="{{ $productType->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>
                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.product-type.actions.edit', ['name' => $productType->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.product-type.components.form-elements')
                    </div>
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                </form>

        </product-type-form>

        </div>
    
</div>

@endsection