

<div class="form-group row align-items-center" :class="{'has-danger': errors.has('product_type'), 'has-success': fields.product_type && fields.product_type.valid }">
    <label for="product_type" class="col-form-label text-md-right" :class="isFormLocalized ? 'col-md-4' : 'col-md-2'">{{ trans('admin.product-type.columns.product_type') }}</label>
        <div :class="isFormLocalized ? 'col-md-4' : 'col-md-9 col-xl-8'">
        <input type="text" v-model="form.product_type" v-validate="'required'" @input="validate($event)" class="form-control" :class="{'form-control-danger': errors.has('product_type'), 'form-control-success': fields.product_type && fields.product_type.valid}" id="product_type" name="product_type" placeholder="{{ trans('admin.product-type.columns.product_type') }}">
        <div v-if="errors.has('product_type')" class="form-control-feedback form-text" v-cloak>@{{ errors.first('product_type') }}</div>
    </div>
</div>

<div class="form-group row align-items-center" :class="{'has-danger': errors.has('requirement'), 'has-success': fields.requirement && fields.requirement.valid }">
    <label for="requirement" class="col-form-label text-md-right" :class="isFormLocalized ? 'col-md-4' : 'col-md-2'">{{ trans('admin.product-type.columns.requirement') }}</label>
    <div :class="isFormLocalized ? 'col-md-4' : 'col-md-9 col-xl-8'">
        <multiselect 
            v-model="form.requirement" 
            placeholder="Select a Special Assistant" 
            label="path" 
            track-by="id" 
            :options="{{ $specialassistants->toJson() }}" 
            :multiple="true"  
            :max="1"
            open-direction="bottom"
        ></multiselect>
        <div v-if="errors.has('requirement')" class="form-control-feedback form-text" v-cloak>@{{ errors.first('requirement') }}</div>
    </div>
</div>

<div class="form-group row align-items-center" :class="{'has-danger': errors.has('requirement'), 'has-success': fields.requirement && fields.requirement.valid }">
    <label for="requirement" class="col-form-label text-md-right" :class="isFormLocalized ? 'col-md-4' : 'col-md-2'">{{ trans('admin.product-type.columns.requirement') }}</label>
    <div :class="isFormLocalized ? 'col-md-4' : 'col-md-9 col-xl-8'">
        <div>
            <textarea class="form-control" v-model="form.requirement" v-validate="'required'" id="requirement" name="requirement" readonly ></textarea>
        </div>
        <div v-if="errors.has('requirement')" class="form-control-feedback form-text" v-cloak>@{{ errors.first('requirement') }}</div>
    </div>
</div>

<div class="form-group row align-items-center" :class="{'has-danger': errors.has('status'), 'has-success': fields.status && fields.status.valid }">
    <label for="status" class="col-form-label text-md-right" :class="isFormLocalized? 'col-md-4' : 'col-md-2'">{{ trans('Status') }}</label>
    <div :class="isFormLocalized? 'col-md-4' : 'col-md-9 col-xl-8'" style="display: flex;">
        <div class="form-check form-check-inline align-items-center" style="margin-right: 15px;">
            <input class="form-check-input" style="margin-bottom: 0.5rem;" type="radio" v-model="form.status" name="status" id="statusYes" value="1">
            <label class="form-check-label" for="statusYes">Active</label>
        </div>
        <div class="form-check form-check-inline align-items-center">
            <input class="form-check-input" style="margin-bottom: 0.5rem;" type="radio" v-model="form.status" name="status" id="statusNo" value="0">
            <label class="form-check-label" for="statusNo">In-active</label>
        </div>
        <div v-if="errors.has('status')" class="form-control-feedback form-text" v-cloak>@{{ errors.first('status') }}</div>
    </div>
</div>



