@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.priority.actions.edit', ['name' => $priority->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <priority-form
                :action="'{{ $priority->resource_url }}'"
                :data="{{ $priority->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.priority.actions.edit', ['name' => $priority->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.priority.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </priority-form>

        </div>
    
</div>

@endsection