@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.polish-type.actions.edit', ['name' => $polishType->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <polish-type-form
                :action="'{{ $polishType->resource_url }}'"
                :data="{{ $polishType->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.polish-type.actions.edit', ['name' => $polishType->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.polish-type.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </polish-type-form>

        </div>
    
</div>

@endsection