@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.party-name.actions.edit', ['name' => $partyName->name]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <party-name-form
                :action="'{{ $partyName->resource_url }}'"
                :data="{{ $partyName->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.party-name.actions.edit', ['name' => $partyName->name]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.party-name.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </party-name-form>

        </div>
    
</div>

@endsection