@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.order.actions.index'))

@section('body')

    <order-listing
        :data="{{ $data->toJson() }}"
        :url="'{{ url('admin/orders') }}'"
        inline-template>

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <i class="ti-align-justify"></i> {{ trans('admin.order.actions.index') }}
                        <a class="btn btn-primary btn-spinner btn-sm pull-right m-b-0" href="{{ url('admin/orders/create') }}" role="button"><i class="ti-plus"></i>&nbsp; {{ trans('admin.order.actions.create') }}</a>
                    </div>
                    <div class="card-content" v-cloak>
                        <div class="card-block">
                            <form @submit.prevent="">
                                <div class="row justify-content-md-between">
                                        <div class="col col-lg-12 col-xl-5 form-group search-box">
                                            <div class="input-group search-bar">
                                                <input class="form-control" placeholder="{{ trans('brackets/admin-ui::admin.placeholder.search') }}" v-model="search" @keyup.enter="filter('search', $event.target.value)" />
                                                <span class="btn btn-primary input-group-addon search-logo" @click="filter('search', search)"><i class="ti-search"></i></span>
                                            </div>

                                            <label>
                                                <select class="form-control" v-model="pagination.state.per_page">
                                                    <option value="10">10</option>
                                                    <option value="25">25</option>
                                                    <option value="100">100</option>
                                                </select>
                                            </label>
                                        </div>
                                </div>
                            </form>

                            <table class="table table-hover table-listing">
                                <thead>
                                    <tr>
                                        {{-- <th class="bulk-checkbox">
                                            <input class="form-check-input" id="enabled" type="checkbox" v-model="isClickedAll" v-validate="''" data-vv-name="enabled"  name="enabled_fake_element" @click="onBulkItemsClickedAllWithPagination()">
                                            <label class="form-check-label" for="enabled">
                                                #
                                            </label>
                                        </th> --}}

                                        <th is='sortable' :column="'id'">{{ trans('admin.order.columns.id') }}</th>
                                        <th is='sortable' :column="'customer_id'">{{ trans('admin.order.columns.customer_id') }}</th>
                                        {{-- <th is='sortable' :column="'order_type'">{{ trans('admin.order.columns.order_type') }}</th> --}}
                                        <th is='sortable' :column="'product_type'">{{ trans('admin.order.columns.product_type') }}</th>
                                        {{-- <th is='sortable' :column="'polish_type'">{{ trans('admin.order.columns.polish_type') }}</th> --}}
                                        <th is='sortable' :column="'metal_type'">{{ trans('admin.order.columns.metal_type') }}</th>
                                        {{-- <th is='sortable' :column="'prongs_type'">{{ trans('admin.order.columns.prongs_type') }}</th>
                                        <th is='sortable' :column="'metal_tone'">{{ trans('admin.order.columns.metal_tone') }}</th> --}}
                                        {{-- <th is='sortable' :column="'ring_size'">{{ trans('admin.order.columns.ring_size') }}</th>
                                        <th is='sortable' :column="'closure'">{{ trans('admin.order.columns.closure') }}</th>
                                        <th is='sortable' :column="'wrist_size'">{{ trans('admin.order.columns.wrist_size') }}</th>
                                        <th is='sortable' :column="'lock_type'">{{ trans('admin.order.columns.lock_type') }}</th>
                                        <th is='sortable' :column="'bale_type'">{{ trans('admin.order.columns.bale_type') }}</th>
                                        <th is='sortable' :column="'necklace_length'">{{ trans('admin.order.columns.necklace_length') }}</th>
                                        <th is='sortable' :column="'length'">{{ trans('admin.order.columns.length') }}</th>
                                        <th is='sortable' :column="'width'">{{ trans('admin.order.columns.width') }}</th>
                                        <th is='sortable' :column="'height'">{{ trans('admin.order.columns.height') }}</th> --}}

                                        {{-- <th is='sortable' :column="'difficulty_level'">{{ trans('admin.order.columns.difficulty_level') }}</th> --}}
                                        <th is='sortable' :column="'priority'">{{ trans('admin.order.columns.priority') }}</th>
                                        {{-- <th is='sortable' :column="'engraving'">{{ trans('admin.order.columns.engraving') }}</th>
                                        <th is='sortable' :column="'gift_wrap'">{{ trans('admin.order.columns.gift_wrap') }}</th>
                                        <th is='sortable' :column="'express_shipping'">{{ trans('admin.order.columns.express_shipping') }}</th> --}}
                                        <th is='sortable' :column="'status'">{{ trans('admin.order.columns.status') }}</th>
                                        {{-- <th is='sortable' :column="'current_process'">{{ trans('admin.order.columns.current_process') }}</th> --}}
                                        <th is='sortable' :column="'order_date'">{{ trans('admin.order.columns.order_date') }}</th>
                                        <th is='sortable' :column="'due_date'">{{ trans('admin.order.columns.due_date') }}</th>
                                        <th is='sortable' :column="'actions'">{{ trans('Actions') }}</th>
                                    </tr>
                                    <tr v-show="(clickedBulkItemsCount > 0) || isClickedAll">
                                        <td class="bg-bulk-info d-table-cell text-center" colspan="28">
                                            <span class="align-middle font-weight-light text-dark">{{ trans('brackets/admin-ui::admin.listing.selected_items') }} @{{ clickedBulkItemsCount }}.  <a href="#" class="text-primary" @click="onBulkItemsClickedAll('/admin/orders')" v-if="(clickedBulkItemsCount < pagination.state.total)"> <i class="fa" :class="bulkCheckingAllLoader ? 'fa-spinner' : ''"></i> {{ trans('brackets/admin-ui::admin.listing.check_all_items') }} @{{ pagination.state.total }}</a> <span class="text-primary">|</span> <a
                                                        href="#" class="text-primary" @click="onBulkItemsClickedAllUncheck()">{{ trans('brackets/admin-ui::admin.listing.uncheck_all_items') }}</a>  </span>

                                            <span class="pull-right pr-2">
                                                <button class="btn btn-sm btn-danger pr-3 pl-3" @click="bulkDelete('/admin/orders/bulk-destroy')">{{ trans('brackets/admin-ui::admin.btn.delete') }}</button>
                                            </span>

                                        </td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(item, index) in collection" :key="item.id" :class="bulkItems[item.id] ? 'bg-bulk' : ''">
                                        {{-- <td class="bulk-checkbox">
                                            <input class="form-check-input" :id="'enabled' + item.id" type="checkbox" v-model="bulkItems[item.id]" v-validate="''" :data-vv-name="'enabled' + item.id"  :name="'enabled' + item.id + '_fake_element'" @click="onBulkItemClicked(item.id)" :disabled="bulkCheckingAllLoader">
                                            <label class="form-check-label" :for="'enabled' + item.id">
                                            </label>
                                        </td> --}}

                                    <td>@{{ item.id }}</td>
                                        {{-- <td>@{{ item.customer_id }}</td> --}}
                                        <td>@{{ item.customer.first_name ?? '-'}}</td>
                                        {{-- <td>@{{ item.order_type }}</td> --}}
                                        <td>@{{ item.product_type.product_type ?? '-'}}</td>
                                        {{-- <td>@{{ item.polish_type }}</td> --}}
                                        <td>@{{ item.metal_type.metal_type ?? '-'}}</td>
                                        {{-- <td>@{{ item.prongs_type }}</td>
                                        <td>@{{ item.metal_tone }}</td> --}}
                                        {{-- <td>@{{ item.ring_size }}</td>
                                        <td>@{{ item.closure }}</td>
                                        <td>@{{ item.wrist_size }}</td>
                                        <td>@{{ item.lock_type }}</td>
                                        <td>@{{ item.bale_type }}</td>
                                        <td>@{{ item.necklace_length }}</td>
                                        <td>@{{ item.length }}</td>
                                        <td>@{{ item.width }}</td>
                                        <td>@{{ item.height }}</td> --}}
                                        
                                        {{-- <td>@{{ item.difficulty_level }}</td> --}}
                                        {{-- <td>
                                        <span class="badge badge-success">
                                           
                                        </span>
                                        </td> --}}
                                        
                                        <td>
                                            <span v-if="item.priority.id === 1" class="badge badge-priority" style="background-color: #EB5E28;">@{{ item.priority.priority }}</span>
                                            <span v-else-if="item.priority.id === 2" class="badge badge-priority" style="background-color:#F3BB45;">@{{ item.priority.priority }}</span>
                                            <span v-else-if="item.priority.id === 3" class="badge badge-priority" style="background-color: #7AC29A;">@{{ item.priority.priority }}</span>
                                            <span v-else class="badge badge-priority">@{{ item.priority.priority }}</span>
                                        </td>
                                        {{-- <td>@{{ item.engraving }}</td>
                                        <td>@{{ item.gift_wrap }}</td>
                                        <td>@{{ item.express_shipping }}</td> --}}
                                        <td>@{{ item.status }}</td>
                                        {{-- <td>@{{ item.current_process }}</td> --}}
                                        <td>@{{ item.order_date | date }}</td>
                                        <td>@{{ item.due_date | date }}</td>
                                        
                                        <td>
                                            <div class="table-icons">
                                                <a class="btn btn-simple btn-info btn-icon table-action view" :href="item.resource_url + '/edit'" title="{{ trans('brackets/admin-ui::admin.btn.edit') }}" role="button"><i class="ti-pencil-alt"></i></a>                                         
                                                <a class="btn btn-simple btn-info btn-icon table-action view" :href="item.resource_url + '/view'" title="{{ trans('brackets/admin-ui::admin.btn.view') }}" role="button"><i class="ti-eye"></i></a>
                                                {{-- <form class="btn btn-simple btn-info btn-icon table-action view" @submit.prevent="deleteItem(item.resource_url)">
                                                    <button type="submit" class="btn btn-simple btn-danger btn-icon table-action remove" title="{{ trans('brackets/admin-ui::admin.btn.delete') }}"><i class="ti-close"></i></button>
                                                </form> --}}
                                                <a class="btn btn-simple btn-info btn-icon table-action remove" href="#" @click.prevent="deleteItem(item.resource_url)" title="{{ trans('brackets/admin-ui::admin.btn.delete') }}" role="button">
                                                    <i class="ti-close"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                            <div class="row pagination-margin" v-if="pagination.state.total > 0">
                                <div class="col-sm">
                                    <span class="pagination-caption">{{ trans('brackets/admin-ui::admin.pagination.overview') }}</span>
                                </div>
                                <div class="col-sm-auto">
                                    <pagination></pagination>
                                </div>
                            </div>

                            <div class="no-items-found" v-if="!collection.length > 0">
                                <i class="icon-magnifier"></i>
                                <h3>{{ trans('brackets/admin-ui::admin.index.no_items') }}</h3>
                                <p>{{ trans('brackets/admin-ui::admin.index.try_changing_items') }}</p>
                                <a class="btn btn-primary btn-spinner" href="{{ url('admin/orders/create') }}" role="button"><i class="ti-plus"></i>&nbsp; {{ trans('admin.order.actions.create') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </order-listing>

@endsection