@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.order.actions.edit', ['name' => $order->id]))
<style>
    .text-width{

        /* width:100% !important; */
    }

    .dynamic-fields-container {
        display: flex;
        flex-wrap: wrap;
    }

    .dynamic-field-block {
        flex: 0 0 48%; /* Adjust width as needed */
        margin: 1%;
        /* border: 1px solid #ccc; */
        padding: 10px;
        box-sizing: border-box;
    }

</style>
@section('body')
    <div class="container-xl">
        <div class="card">

        <order-form
                :diamondorder="{{ $diamondorder }}"
                :action="'{{ $order->resource_url }}'"
                :data="{{ $order->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.order.actions.edit', ['name' => $order->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.order.components.form-elements')
                    </div>
                    
                 
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                        {{-- <div id="demo_button">
                            <button type="button">demo_button</button>
                        </div> --}}
                    </div>
                    
                </form>

        </order-form>

        </div> 
    
</div>

@endsection