@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.metal-tone.actions.edit', ['name' => $metalTone->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <metal-tone-form
                :action="'{{ $metalTone->resource_url }}'"
                :data="{{ $metalTone->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.metal-tone.actions.edit', ['name' => $metalTone->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.metal-tone.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </metal-tone-form>

        </div>
    
</div>

@endsection