@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.lock-type.actions.edit', ['name' => $lockType->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <lock-type-form
                :action="'{{ $lockType->resource_url }}'"
                :data="{{ $lockType->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.lock-type.actions.edit', ['name' => $lockType->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.lock-type.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </lock-type-form>

        </div>
    
</div>

@endsection