@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.diamond-shape.actions.edit', ['name' => $diamondShape->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <diamond-shape-form
                :action="'{{ $diamondShape->resource_url }}'"
                :data="{{ $diamondShape->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.diamond-shape.actions.edit', ['name' => $diamondShape->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.diamond-shape.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </diamond-shape-form>

        </div>
    
</div>

@endsection