@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.country.actions.index'))

@section('body')

    <country-listing
        :data="{{ $data->toJson() }}"
        :url="'{{ url('admin/countries') }}'"
        inline-template>

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <i class="ti-align-justify"></i> {{ trans('admin.country.actions.index') }}
                        <a class="btn btn-primary btn-spinner btn-sm pull-right m-b-0" href="{{ url('admin/countries/create') }}" role="button"><i class="ti-plus"></i>&nbsp; {{ trans('admin.country.actions.create') }}</a>
                    </div>
                    <div class="card-content" v-cloak>
                        <div class="card-block">
                            <form @submit.prevent="">
                                <div class="row justify-content-md-between">
                                        <div class="col col-lg-12 col-xl-5 form-group search-box">
                                            <div class="input-group search-bar">
                                                <input class="form-control" placeholder="{{ trans('brackets/admin-ui::admin.placeholder.search') }}" v-model="search" @keyup.enter="filter('search', $event.target.value)" />
                                                <span class="btn btn-primary input-group-addon search-logo" @click="filter('search', search)"><i class="ti-search"></i></span>
                                            </div>

                                            <label>
                                                <select class="form-control" v-model="pagination.state.per_page">
                                                    <option value="10">10</option>
                                                    <option value="25">25</option>
                                                    <option value="100">100</option>
                                                </select>
                                            </label>
                                        </div>
                                </div>


                            </form>

                            <table class="table table-hover table-listing">
                                <thead>
                                    <tr>
                                        <th class="bulk-checkbox">
                                            <input class="form-check-input" id="enabled" type="checkbox" v-model="isClickedAll" v-validate="''" data-vv-name="enabled"  name="enabled_fake_element" @click="onBulkItemsClickedAllWithPagination()">
                                            <label class="form-check-label" for="enabled">
                                                #
                                            </label>
                                        </th>

                                        <th is='sortable' :column="'id'">{{ trans('admin.country.columns.id') }}</th>
                                        <th is='sortable' :column="'name'">{{ trans('admin.country.columns.name') }}</th>
                                        <th is='sortable' :column="'status'">{{ trans('admin.country.columns.status') }}</th>

                                        <th is='sortable' :column="'actions'">{{ trans('Actions') }}</th>
                                    </tr>
                                    <tr v-show="(clickedBulkItemsCount > 0) || isClickedAll">
                                        <td class="bg-bulk-info d-table-cell text-center" colspan="5">
                                            <span class="align-middle font-weight-light text-dark">{{ trans('brackets/admin-ui::admin.listing.selected_items') }} @{{ clickedBulkItemsCount }}.  <a href="#" class="text-primary" @click="onBulkItemsClickedAll('/admin/countries')" v-if="(clickedBulkItemsCount < pagination.state.total)"> <i class="fa" :class="bulkCheckingAllLoader ? 'fa-spinner' : ''"></i> {{ trans('brackets/admin-ui::admin.listing.check_all_items') }} @{{ pagination.state.total }}</a> <span class="text-primary">|</span> <a
                                                        href="#" class="text-primary" @click="onBulkItemsClickedAllUncheck()">{{ trans('brackets/admin-ui::admin.listing.uncheck_all_items') }}</a>  </span>

                                            <span class="pull-right pr-2">
                                                <button class="btn btn-sm btn-danger pr-3 pl-3" @click="bulkDelete('/admin/countries/bulk-destroy')">{{ trans('brackets/admin-ui::admin.btn.delete') }}</button>
                                            </span>

                                        </td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(item, index) in collection" :key="item.id" :class="bulkItems[item.id] ? 'bg-bulk' : ''">
                                        <td class="bulk-checkbox">
                                            <input class="form-check-input" :id="'enabled' + item.id" type="checkbox" v-model="bulkItems[item.id]" v-validate="''" :data-vv-name="'enabled' + item.id"  :name="'enabled' + item.id + '_fake_element'" @click="onBulkItemClicked(item.id)" :disabled="bulkCheckingAllLoader">
                                            <label class="form-check-label" :for="'enabled' + item.id">
                                            </label>
                                        </td>

                                    <td>@{{ item.id }}</td>
                                        <td>@{{ item.name }}</td>
                                        {{-- <td>
                                            <label class="switch switch-3d switch-success">
                                                <input type="checkbox" class="switch-input" v-model="collection[index].status" @change="toggleSwitch(item.resource_url, 'status', collection[index])">
                                                <span class="switch-slider"></span>
                                            </label>
                                        </td> --}}
                                        <td>
                                            <label class="switch switch-3d switch-success">
                                                <input type="checkbox" class="switch-input" v-model="collection[index].status" @change="toggleSwitch(item.resource_url, 'status', collection[index])">
                                                <span class="switch-slider"></span>
                                            </label>
                                        </td>
                                        {{-- <td class="text-right">
                                            <div class="col-md-4">
                                                <p class="category">With Icons</p>
                                                <div class="bootstrap-switch bootstrap-switch-wrapper bootstrap-switch-on bootstrap-switch-animate" style="width: 72px;"><div class="bootstrap-switch-container" style="width: 122px; margin-left: 0px;"><span class="bootstrap-switch-handle-on bootstrap-switch-" style="width: 50px;"><i class="fa fa-check"></i></span><span class="bootstrap-switch-label" style="width: 26px;">&nbsp;</span><span class="bootstrap-switch-handle-off bootstrap-switch-default" style="width: 50px;"><i class="fa fa-times"></i></span><input type="checkbox" class="switch-icon" checked=""></div></div>
                                                <div class="bootstrap-switch bootstrap-switch-wrapper bootstrap-switch-animate bootstrap-switch-off" style="width: 72px;"><div class="bootstrap-switch-container" style="width: 122px; margin-left: -50px;"><span class="bootstrap-switch-handle-on bootstrap-switch-" style="width: 50px;"><i class="fa fa-check"></i></span><span class="bootstrap-switch-label" style="width: 26px;">&nbsp;</span><span class="bootstrap-switch-handle-off bootstrap-switch-default" style="width: 50px;"><i class="fa fa-times"></i></span><input type="checkbox" class="switch-icon"></div></div>
                                                </div>
                                        </td> --}}
{{-- 
                                    <td>
                                        <div class="table-icons">
                                            <a rel="tooltip" title="" class="btn btn-simple btn-info btn-icon table-action view" href="javascript:void(0)" data-original-title="View">
                                                <i class="ti-image"></i>
                                            </a>
                                            <a rel="tooltip" title="" class="btn btn-simple btn-warning btn-icon table-action edit" href="javascript:void(0)" data-original-title="Edit">
                                                <i class="ti-pencil-alt"></i>
                                            </a>
                                            <a rel="tooltip" title="" class="btn btn-simple btn-danger btn-icon table-action remove" href="javascript:void(0)" data-original-title="Remove">
                                                <i class="ti-close"></i>
                                            </a>
                                        </div>

                                    </td> --}}


                                        
                                        <td>
                                            <div class="table-icons">
                                                {{-- <div class="col-auto"> --}}
                                                    {{-- <a class="btn btn-simple btn-info btn-icon table-action view" :href="item.resource_url + '/edit'" title="{{ trans('brackets/admin-ui::admin.btn.edit') }}" role="button">
                                                        <i class="ti-pencil-alt"></i>
                                                    </a> --}}
                                                {{-- </div> --}}
                                                
                                                <a class="btn btn-simple btn-info btn-icon table-action view" :href="item.resource_url + '/edit'" title="{{ trans('brackets/admin-ui::admin.btn.edit') }}" role="button">
                                                    <i class="ti-pencil-alt"></i>
                                                </a>
                                                <form class="btn btn-simple btn-info btn-icon table-action view"  @submit.prevent="deleteItem(item.resource_url)">
                                                    <button type="submit" class="btn btn-simple btn-danger btn-icon table-action remove" title="{{ trans('brackets/admin-ui::admin.btn.delete') }}"><i class="ti-close"></i></button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                            <div class="row pagination-margin" v-if="pagination.state.total > 0">
                                <div class="col-sm">
                                    <span class="pagination-caption">{{ trans('brackets/admin-ui::admin.pagination.overview') }}</span>
                                </div>
                                <div class="col-sm-auto">
                                    <pagination></pagination>
                                </div>
                            </div>

                            <div class="no-items-found" v-if="!collection.length > 0">
                                <i class="icon-magnifier"></i>
                                <h3>{{ trans('brackets/admin-ui::admin.index.no_items') }}</h3>
                                <p>{{ trans('brackets/admin-ui::admin.index.try_changing_items') }}</p>
                                <a class="btn btn-primary btn-spinner" href="{{ url('admin/countries/create') }}" role="button"><i class="ti-plus"></i>&nbsp; {{ trans('admin.country.actions.create') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </country-listing>

@endsection