@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.closure.actions.edit', ['name' => $closure->id]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <closure-form
                :action="'{{ $closure->resource_url }}'"
                :data="{{ $closure->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.closure.actions.edit', ['name' => $closure->id]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.closure.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </closure-form>

        </div>
    
</div>

@endsection