@extends('admin.paper-theme-layout.default')

@section('title', trans('admin.broker-name.actions.edit', ['name' => $brokerName->name]))

@section('body')

    <div class="container-xl">
        <div class="card">

            <broker-name-form
                :action="'{{ $brokerName->resource_url }}'"
                :data="{{ $brokerName->toJson() }}"
                v-cloak
                inline-template>
            
                <form class="form-horizontal form-edit" method="post" @submit.prevent="onSubmit" :action="action" novalidate>


                    <div class="card-header">
                        <i class="fa fa-pencil"></i> {{ trans('admin.broker-name.actions.edit', ['name' => $brokerName->name]) }}
                    </div>

                    <div class="card-content">
                        @include('admin.broker-name.components.form-elements')
                    </div>
                    
                    
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" :disabled="submiting">
                            <i class="fa" :class="submiting ? 'fa-spinner' : 'fa-download'"></i>
                            {{ trans('brackets/admin-ui::admin.btn.save') }}
                        </button>
                    </div>
                    
                </form>

        </broker-name-form>

        </div>
    
</div>

@endsection