import AppForm from '../app-components/Form/AppForm';

Vue.component('order-form', {
    props:['diamondorder'],
    mixins: [AppForm],
    data: function() {
        return {
            form: {
                customer_id:  '' ,
                order_type:  '' ,
                product_type:  '' ,
                polish_type:  '' ,
                metal_type:  '' ,
                prongs_type:  '' ,
                metal_tone:  '' ,
                ring_size:  '' ,
                closure:  '' ,
                wrist_size:  '' ,
                lock_type:  '' ,
                bale_type:  '' ,
                necklace_length:  '' ,
                length:  '' ,
                width:  '' ,
                height:  '' ,
                comment:  '' ,
                order_date:  '' ,
                due_date:  '' ,
                difficulty_level:  '' ,
                priority:  '' ,
                engraving:  0 ,
                engraving_text:  '' ,
                engraving_note:  '' ,
                engraving_example:  '' ,
                gift_wrap:  0 ,
                express_shipping:  0 ,
                status:  '' ,
                current_process:  '' ,
                purity:'',
                amount:'',
                paid_amount:'',
                jewellery_certificate_req:'',
                payment_type:'',
                dynamicFields: []
            },
            productTypeFields: {
                1: ['ring_size', 'metal_type', 'metal_purity', 'metal_tone'],
                2: ['ring_size', 'metal_type', 'metal_purity', 'metal_tone'],
                3: ['ring_size', 'metal_type', 'metal_purity', 'metal_tone'],
                4: ['closure', 'metal_type', 'metal_purity', 'metal_tone'],
                5: ['wrist_size', 'lock_type','metal_type', 'metal_purity', 'metal_tone'],
                6: ['bale_type', 'metal_type', 'metal_purity', 'metal_tone'],
                7: ['necklace_length', 'metal_type', 'metal_purity', 'metal_tone'],
                // Add more mappings as needed
            }
        }
    },
    computed: {
        showRingSize() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('ring_size');
        },
        showMetalType() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('metal_type');
        },
        showMetalPurity() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('metal_purity');
        },
        showMetalTone() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('metal_tone');
        },
        showClosure() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('closure');
        },
        showWristSize() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('wrist_size');
        },
        showLockType() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('lock_type');
        },
        showBaleType() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('bale_type');
        },
        showNecklace() {
            return this.productTypeFields[this.form.product_type] && this.productTypeFields[this.form.product_type].includes('necklace_length');
        }

        //necklace_length

    },
    methods: {
        addDynamicFields() {
            this.form.dynamicFields.push({
                order_id:  '' ,
                diamond_type:  '' ,
                diamond_stock_type:  '' ,
                diamond_shape:  '' ,
                carat_weight:  '' ,
                stone_color:  '' ,
                length:  '' ,
                width:  '' ,
                height:  '' ,
                certificate_number:  '' ,
            });
           
            console.log('diamond_data',this.form.dynamicFields);
        },
        removeDynamicFields(index) {
            this.form.dynamicFields.splice(index, 1);
         

            console.log('diamond_data',this.form.dynamicFields);
        }
    },
    created(){
        console.log('diamond_data',this.diamondorder);
        if (this.diamondorder) {
            this.form.dynamicFields = this.diamondorder;
        }
    }

});
