<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('diamond_order', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id');
            $table->unsignedBigInteger('diamond_type'); // Foreign key
            $table->unsignedBigInteger('diamond_stock_type')->nullable();
            $table->unsignedBigInteger('diamond_shape'); // Foreign key
            $table->unsignedBigInteger('carat_weight'); // Foreign key
            $table->unsignedBigInteger('stone_color'); // Foreign key
            $table->float('length')->nullable();  
            $table->float('width')->nullable();  
            $table->float('height')->nullable();
            $table->string('certificate_number')->nullable(); 
            $table->timestamps();

            $table->foreign('diamond_type')->references('id')->on('diamond_type');
            $table->foreign('diamond_shape')->references('id')->on('diamond_shape');
            $table->foreign('carat_weight')->references('id')->on('carat_weight');
            $table->foreign('stone_color')->references('id')->on('stone_color');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('diamond_order');
    }
};
