<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {

            $table->id(); // Auto-incrementing ID
            $table->unsignedBigInteger('customer_id'); // Foreign key to customers table
            $table->unsignedBigInteger('order_type')->nullable(); //old new remake 
            $table->unsignedBigInteger('product_type'); // Foreign key to product_types table
            $table->unsignedBigInteger('polish_type')->nullable();// Foreign key to polish_types table
            $table->unsignedBigInteger('metal_type')->nullable(); // Foreign key to metal_types table
            $table->unsignedBigInteger('prongs_type')->nullable(); // Foreign key
            $table->unsignedBigInteger('metal_tone')->nullable(); // Foreign key
            $table->unsignedBigInteger('ring_size')->nullable(); // Foreign key
            $table->unsignedBigInteger('closure')->nullable(); // Foreign key
            $table->unsignedBigInteger('wrist_size')->nullable();// Foreign key
            $table->unsignedBigInteger('lock_type')->nullable(); // Foreign key
            $table->unsignedBigInteger('bale_type')->nullable(); // Foreign key
            $table->float('necklace_length')->nullable(); 
         
            
            $table->float('length')->nullable();  
            $table->float('width')->nullable();  
            $table->float('height')->nullable();  
            $table->text('comment')->nullable(); 
            $table->timestamp('order_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->date('due_date')->nullable(); 
            $table->unsignedBigInteger('difficulty_level')->nullable();
            $table->unsignedBigInteger('priority')->nullable();
            $table->boolean('engraving')->nullable();
            $table->text('engraving_text')->nullable();
            $table->text('engraving_note')->nullable();
            $table->text('engraving_example')->nullable();
            $table->boolean('gift_wrap')->nullable();
            $table->boolean('express_shipping')->nullable();
            $table->string('status'); // Status of the order (recived , processing , delivered)
            $table->string('current_process'); // Current process of the order
            $table->timestamps(); // Created at and updated at timestamps
            // Define foreign key constraints
            $table->foreign('customer_id')->references('id')->on('customers');
            $table->foreign('product_type')->references('id')->on('product_type');
            $table->foreign('polish_type')->references('id')->on('polish_type')->onDelete('set null');
            $table->foreign('metal_type')->references('id')->on('metal_type')->onDelete('set null');
            $table->foreign('prongs_type')->references('id')->on('prongs_type')->onDelete('set null');
            $table->foreign('metal_tone')->references('id')->on('metal_tone')->onDelete('set null');
            $table->foreign('priority')->references('id')->on('priority')->onDelete('set null');
            $table->foreign('ring_size')->references('id')->on('ring_size')->onDelete('set null');
            $table->foreign('closure')->references('id')->on('closure')->onDelete('set null');
            $table->foreign('wrist_size')->references('id')->on('wrist_size')->onDelete('set null');
            $table->foreign('lock_type')->references('id')->on('lock_type')->onDelete('set null');
            $table->foreign('bale_type')->references('id')->on('bale_type')->onDelete('set null');
            //metal_tone  closure 
       
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
