<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->unsignedBigInteger('party_id')->nullable();
            $table->unsignedBigInteger('broker_id')->nullable();
            $table->text('address_1')->nullable();
            $table->text('address_2')->nullable();
            $table->string('city')->nullable(); 
            $table->string('state')->nullable(); 
            $table->string('zipcode')->nullable(); 
            $table->unsignedBigInteger('country_id')->nullable(); 
            $table->string('number')->nullable();
            $table->string('email')->nullable();
            $table->unsignedTinyInteger('status')->default(1)->nullable();
            $table->timestamps();

            $table->foreign('party_id')->references('id')->on('party_name')->onDelete('set null');
            $table->foreign('broker_id')->references('id')->on('broker_name')->onDelete('set null');
            $table->foreign('country_id')->references('id')->on('countries')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
