<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('broker_name', function (Blueprint $table) {
            $table->id();
            $table->string('name_code')->unique();
            $table->string('name')->nullable()->unique();
            $table->string('number')->nullable();
            $table->string('email')->nullable();
            $table->unsignedTinyInteger('status')->default(1)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('broker_name');
    }
};
