<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(Brackets\AdminAuth\Models\AdminUser::class, function (Faker\Generator $faker) {
    return [
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'email' => $faker->email,
        'password' => bcrypt($faker->password),
        'remember_token' => null,
        'activated' => true,
        'forbidden' => $faker->boolean(),
        'language' => 'en',
        'deleted_at' => null,
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        'last_login_at' => $faker->dateTime,
        
    ];
});/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Country::class, static function (Faker\Generator $faker) {
    return [
        'name' => $faker->firstName,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\DiamondType::class, static function (Faker\Generator $faker) {
    return [
        'type' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\DiamondShape::class, static function (Faker\Generator $faker) {
    return [
        'shape' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\StoneColor::class, static function (Faker\Generator $faker) {
    return [
        'stone_color' => $faker->sentence,
        'diamond_type' => $faker->boolean(),
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\MetalType::class, static function (Faker\Generator $faker) {
    return [
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\MetalType::class, static function (Faker\Generator $faker) {
    return [
        'metal_type' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\MetalPurity::class, static function (Faker\Generator $faker) {
    return [
        'purity' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\MetalTone::class, static function (Faker\Generator $faker) {
    return [
        'metal_tone' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Closure::class, static function (Faker\Generator $faker) {
    return [
        'closure' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\RingSize::class, static function (Faker\Generator $faker) {
    return [
        'size' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\CaratWeight::class, static function (Faker\Generator $faker) {
    return [
        'weight' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\WristSize::class, static function (Faker\Generator $faker) {
    return [
        'size' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\PartyName::class, static function (Faker\Generator $faker) {
    return [
        'name_code' => $faker->sentence,
        'name' => $faker->firstName,
        'number' => $faker->sentence,
        'email' => $faker->email,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\BrokerName::class, static function (Faker\Generator $faker) {
    return [
        'name_code' => $faker->sentence,
        'name' => $faker->firstName,
        'number' => $faker->sentence,
        'email' => $faker->email,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\LockType::class, static function (Faker\Generator $faker) {
    return [
        'lock_type' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\PolishType::class, static function (Faker\Generator $faker) {
    return [
        'polish_type' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\ProngsType::class, static function (Faker\Generator $faker) {
    return [
        'prongs_type' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Priority::class, static function (Faker\Generator $faker) {
    return [
        'priority' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\ProductType::class, static function (Faker\Generator $faker) {
    return [
        'product_type' => $faker->sentence,
        'requirement' => $faker->text(),
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Customer::class, static function (Faker\Generator $faker) {
    return [
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'party_id' => $faker->sentence,
        'broker_id' => $faker->sentence,
        'address_1' => $faker->text(),
        'address_2' => $faker->text(),
        'city' => $faker->sentence,
        'state' => $faker->sentence,
        'zipcode' => $faker->sentence,
        'country_id' => $faker->sentence,
        'number' => $faker->sentence,
        'email' => $faker->email,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\BaleType::class, static function (Faker\Generator $faker) {
    return [
        'bale_type' => $faker->sentence,
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Order::class, static function (Faker\Generator $faker) {
    return [
        'customer_id' => $faker->sentence,
        'order_type' => $faker->sentence,
        'product_type' => $faker->sentence,
        'polish_type' => $faker->sentence,
        'metal_type' => $faker->sentence,
        'prongs_type' => $faker->sentence,
        'metal_tone' => $faker->sentence,
        'ring_size' => $faker->sentence,
        'closure' => $faker->sentence,
        'wrist_size' => $faker->sentence,
        'lock_type' => $faker->sentence,
        'bale_type' => $faker->sentence,
        'necklace_length' => $faker->randomFloat,
        'length' => $faker->randomFloat,
        'width' => $faker->randomFloat,
        'height' => $faker->randomFloat,
        'comment' => $faker->text(),
        'order_date' => $faker->dateTime,
        'due_date' => $faker->date(),
        'difficulty_level' => $faker->sentence,
        'priority' => $faker->sentence,
        'engraving' => $faker->boolean(),
        'engraving_text' => $faker->text(),
        'engraving_note' => $faker->text(),
        'engraving_example' => $faker->text(),
        'gift_wrap' => $faker->boolean(),
        'express_shipping' => $faker->boolean(),
        'status' => $faker->sentence,
        'current_process' => $faker->sentence,
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\DiamondOrder::class, static function (Faker\Generator $faker) {
    return [
        'order_id' => $faker->sentence,
        'diamond_type' => $faker->sentence,
        'diamond_stock_type' => $faker->sentence,
        'diamond_shape' => $faker->sentence,
        'carat_weight' => $faker->sentence,
        'stone_color' => $faker->sentence,
        'length' => $faker->randomFloat,
        'width' => $faker->randomFloat,
        'height' => $faker->randomFloat,
        'certificate_number' => $faker->sentence,
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Role::class, static function (Faker\Generator $faker) {
    return [
        'name' => $faker->firstName,
        'guard_name' => $faker->sentence,
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\Permission::class, static function (Faker\Generator $faker) {
    return [
        'name' => $faker->firstName,
        'guard_name' => $faker->sentence,
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\QcDepartment::class, static function (Faker\Generator $faker) {
    return [
        'key' => $faker->sentence,
        'value' => $faker->text(),
        'status' => $faker->boolean(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(App\Models\QcQuestion::class, static function (Faker\Generator $faker) {
    return [
        'department' => $faker->sentence,
        'question' => $faker->text(),
        'created_at' => $faker->dateTime,
        'updated_at' => $faker->dateTime,
        
        
    ];
});
