<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WristSize extends Model
{
    protected $table = 'wrist_size';

    protected $fillable = [
        'size',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/wrist-sizes/'.$this->getKey());
    }
}
