<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StoneColor extends Model
{
    protected $table = 'stone_color';

    protected $fillable = [
        'stone_color',
        'diamond_type',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/stone-colors/'.$this->getKey());
    }
}
