<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RingSize extends Model
{
    protected $table = 'ring_size';

    protected $fillable = [
        'size',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/ring-sizes/'.$this->getKey());
    }
}
