<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QcQuestion extends Model 
{
    protected $fillable = [
        'department',
        'question',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/qc-questions/'.$this->getKey());
    }

    public function department_type()
    {
        return $this->belongsTo(QcDepartment::class, 'department');
    }
}
