<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QcDepartment extends Model
{
    protected $table = 'qc_department';

    protected $fillable = [
        'key',
        'value',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/qc-departments/'.$this->getKey());
    }
}
