<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PolishType extends Model
{
    protected $table = 'polish_type';

    protected $fillable = [
        'polish_type',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/polish-types/'.$this->getKey());
    }
}
