<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PartyName extends Model
{
    protected $table = 'party_name';

    protected $fillable = [
        'name_code',
        'name',
        'number',
        'email',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/party-names/'.$this->getKey());
    }
}
