<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'customer_id',
        'order_type',
        'product_type',
        'polish_type',
        'metal_type',
        'prongs_type',
        'metal_tone',
        'ring_size',
        'closure',
        'wrist_size',
        'lock_type',
        'bale_type',
        'necklace_length',
        'length',
        'width',
        'height',
        'comment',
        'order_date',
        'due_date',
        'difficulty_level',
        'priority',
        'engraving',
        'engraving_text',
        'engraving_note',
        'engraving_example',
        'gift_wrap',
        'express_shipping',
        'status',
        'amount',
        'purity',
        'paid_amount',
        'jewellery_certificate_req',
        'payment_type',
        'current_process',
    
    ];
    
    
    protected $dates = [
        'order_date',
        'due_date',
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/orders/'.$this->getKey());
    }

    // public function customer(){
    //     return $this->belongsTo(Customer::class,'customer_id');
    // }
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function productType()
    {
        return $this->belongsTo(ProductType::class, 'product_type');
    }

    public function polishType()
    {
        return $this->belongsTo(PolishType::class, 'polish_type');
    }

 
    public function metalType()
    {
        return $this->belongsTo(MetalType::class, 'metal_type');
    }

    public function priority()
    {
        return $this->belongsTo(Priority::class, 'priority');
    }
}
