<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MetalType extends Model
{
    protected $table = 'metal_type';

    protected $fillable = [
        'metal_type',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/metal-types/'.$this->getKey());
    }
}
