<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MetalTone extends Model
{
    protected $table = 'metal_tone';

    protected $fillable = [
        'metal_tone',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/metal-tones/'.$this->getKey());
    }
}
