<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MetalPurity extends Model
{
    protected $table = 'metal_purity';

    protected $fillable = [
        'purity',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/metal-purities/'.$this->getKey());
    }
}
