<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LockType extends Model
{
    protected $table = 'lock_type';

    protected $fillable = [
        'lock_type',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/lock-types/'.$this->getKey());
    }
}
