<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiamondType extends Model
{
    protected $table = 'diamond_type';

    protected $fillable = [
        'type',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/diamond-types/'.$this->getKey());
    }
}
