<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiamondShape extends Model
{
    protected $table = 'diamond_shape';

    protected $fillable = [
        'shape',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/diamond-shapes/'.$this->getKey());
    }
}
