<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiamondOrder extends Model
{
    protected $table = 'diamond_order';

    protected $fillable = [
        'order_id',
        'diamond_type',
        'diamond_stock_type',
        'diamond_shape',
        'carat_weight',
        'stone_color',
        'length',
        'width',
        'height',
        'certificate_number',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/diamond-orders/'.$this->getKey());
    }
}
