<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BaleType extends Model
{
    protected $table = 'bale_type';

    protected $fillable = [
        'bale_type',
        'status',
    
    ];
    
    
    protected $dates = [
        'created_at',
        'updated_at',
    
    ];
    
    protected $appends = ['resource_url'];

    /* ************************ ACCESSOR ************************* */

    public function getResourceUrlAttribute()
    {
        return url('/admin/bale-types/'.$this->getKey());
    }
}
