<?php

namespace App\Http\Requests\Admin\PartyName;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;

class UpdatePartyName extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Gate::allows('admin.party-name.edit', $this->partyName);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name_code' => ['sometimes', Rule::unique('party_name', 'name_code')->ignore($this->partyName->getKey(), $this->partyName->getKeyName()), 'string'],
            'name' => ['nullable', Rule::unique('party_name', 'name')->ignore($this->partyName->getKey(), $this->partyName->getKeyName()), 'string'],
            'number' => ['nullable', 'string'],
            'email' => ['nullable', 'email', 'string'],
            'status' => ['nullable', 'boolean'],
            
        ];
    }

    /**
     * Modify input data
     *
     * @return array
     */
    public function getSanitized(): array
    {
        $sanitized = $this->validated();


        //Add your code for manipulation with request data here

        return $sanitized;
    }
}
