<?php

namespace App\Http\Requests\Admin\Order;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;

class UpdateOrder extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Gate::allows('admin.order.edit', $this->order);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'customer_id' => ['sometimes'],
            'order_type' => ['nullable'],
            'product_type' => ['sometimes'],
            'polish_type' => ['nullable'],
            'metal_type' => ['nullable'],
            'purity' => ['nullable'],
            'prongs_type' => ['nullable'],
            'metal_tone' => ['nullable'],
            'ring_size' => ['nullable'],
            'closure' => ['nullable'],
            'wrist_size' => ['nullable'],
            'lock_type' => ['nullable'],
            'bale_type' => ['nullable'],
            'necklace_length' => ['nullable', 'numeric'],
            'length' => ['nullable', 'numeric'],
            'width' => ['nullable', 'numeric'],
            'height' => ['nullable', 'numeric'],
            'comment' => ['nullable', 'string'],
            'order_date' => ['sometimes', 'date'],
            'due_date' => ['nullable'],
            'difficulty_level' => ['nullable'],
            'priority' => ['nullable'],
            'engraving' => ['nullable', 'boolean'],
            'engraving_text' => ['nullable', 'string'],
            'engraving_note' => ['nullable', 'string'],
            'engraving_example' => ['nullable', 'string'],
            'gift_wrap' => ['nullable', 'boolean'],
            'express_shipping' => ['nullable', 'boolean'],
            'payment_type'=>['nullable', 'boolean'],
            'status' => ['nullable'],
            'amount'=>['sometimes'],
            'paid_amount'=>['sometimes'],
            'jewellery_certificate_req' => ['nullable'],
            'current_process' => ['nullable'],
            
        ];
    }

    /**
     * Modify input data
     *
     * @return array
     */
    public function getSanitized(): array
    {
        $sanitized = $this->validated();


        //Add your code for manipulation with request data here

        return $sanitized;
    }
}
