<?php

namespace App\Http\Requests\Admin\DiamondOrder;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;

class UpdateDiamondOrder extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Gate::allows('admin.diamond-order.edit', $this->diamondOrder);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'order_id' => ['sometimes', 'string'],
            'diamond_type' => ['sometimes', 'string'],
            'diamond_stock_type' => ['nullable', 'string'],
            'diamond_shape' => ['sometimes', 'string'],
            'carat_weight' => ['sometimes', 'string'],
            'stone_color' => ['sometimes', 'string'],
            'length' => ['nullable', 'numeric'],
            'width' => ['nullable', 'numeric'],
            'height' => ['nullable', 'numeric'],
            'certificate_number' => ['nullable', 'string'],
            
        ];
    }

    /**
     * Modify input data
     *
     * @return array
     */
    public function getSanitized(): array
    {
        $sanitized = $this->validated();


        //Add your code for manipulation with request data here

        return $sanitized;
    }
}
