<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\WristSize\BulkDestroyWristSize;
use App\Http\Requests\Admin\WristSize\DestroyWristSize;
use App\Http\Requests\Admin\WristSize\IndexWristSize;
use App\Http\Requests\Admin\WristSize\StoreWristSize;
use App\Http\Requests\Admin\WristSize\UpdateWristSize;
use App\Models\WristSize;
use Brackets\AdminListing\Facades\AdminListing;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class WristSizeController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @param IndexWristSize $request
     * @return array|Factory|View
     */
    public function index(IndexWristSize $request)
    {
        // create and AdminListing instance for a specific model and
        $data = AdminListing::create(WristSize::class)->processRequestAndGet(
            // pass the request with params
            $request,

            // set columns to query
            ['id', 'size', 'status'],

            // set columns to searchIn
            ['id', 'size']
        );

        if ($request->ajax()) {
            if ($request->has('bulk')) {
                return [
                    'bulkItems' => $data->pluck('id')
                ];
            }
            return ['data' => $data];
        }

        return view('admin.wrist-size.index', ['data' => $data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function create()
    {
        $this->authorize('admin.wrist-size.create');

        return view('admin.wrist-size.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreWristSize $request
     * @return array|RedirectResponse|Redirector
     */
    public function store(StoreWristSize $request)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Store the WristSize
        $wristSize = WristSize::create($sanitized);

        if ($request->ajax()) {
            return ['redirect' => url('admin/wrist-sizes'), 'message' => trans('brackets/admin-ui::admin.operation.succeeded')];
        }

        return redirect('admin/wrist-sizes');
    }

    /**
     * Display the specified resource.
     *
     * @param WristSize $wristSize
     * @throws AuthorizationException
     * @return void
     */
    public function show(WristSize $wristSize)
    {
        $this->authorize('admin.wrist-size.show', $wristSize);

        // TODO your code goes here
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param WristSize $wristSize
     * @throws AuthorizationException
     * @return Factory|View
     */
    public function edit(WristSize $wristSize)
    {
        $this->authorize('admin.wrist-size.edit', $wristSize);


        return view('admin.wrist-size.edit', [
            'wristSize' => $wristSize,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateWristSize $request
     * @param WristSize $wristSize
     * @return array|RedirectResponse|Redirector
     */
    public function update(UpdateWristSize $request, WristSize $wristSize)
    {
        // Sanitize input
        $sanitized = $request->getSanitized();

        // Update changed values WristSize
        $wristSize->update($sanitized);

        if ($request->ajax()) {
            return [
                'redirect' => url('admin/wrist-sizes'),
                'message' => trans('brackets/admin-ui::admin.operation.succeeded'),
            ];
        }

        return redirect('admin/wrist-sizes');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DestroyWristSize $request
     * @param WristSize $wristSize
     * @throws Exception
     * @return ResponseFactory|RedirectResponse|Response
     */
    public function destroy(DestroyWristSize $request, WristSize $wristSize)
    {
        $wristSize->delete();

        if ($request->ajax()) {
            return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resources from storage.
     *
     * @param BulkDestroyWristSize $request
     * @throws Exception
     * @return Response|bool
     */
    public function bulkDestroy(BulkDestroyWristSize $request) : Response
    {
        DB::transaction(static function () use ($request) {
            collect($request->data['ids'])
                ->chunk(1000)
                ->each(static function ($bulkChunk) {
                    WristSize::whereIn('id', $bulkChunk)->delete();

                    // TODO your code goes here
                });
        });

        return response(['message' => trans('brackets/admin-ui::admin.operation.succeeded')]);
    }
}
